import os
import streamlit as st
from langchain.vectorstores import Chroma 
from langchain.embeddings import GooglePalmEmbeddings
from langchain.llms import GooglePalm
from langchain.chains import RetrievalQA
from langchain.llms import GooglePalm
from langchain.retrievers.self_query.base import SelfQueryRetriever
from langchain.chains.query_constructor.base import AttributeInfo


os.environ["GOOGLE_API_KEY"] = "AIzaSyAETvYdW8PHW0uEgXAmMFs0jcJCo5Ffzc8"

def pretty_print(llm_response):
    #print(llm_response['query'])
    print(llm_response['result'])

    print('\nSources: ')
    for source in llm_response["source_documents"]:
        print('\n', source.page_content)

# Define your RAG-based language model here
def rag_language_model(query):
# Your code to generate the response using the RAG-based language model
    chrome_db = Chroma(persist_directory='../data/i3_crisp', embedding_function=GooglePalmEmbeddings())
    metadata_info = [AttributeInfo(
        name="Keywords",
        description="Major keywords that appear and provide context",
        type="string"
    )]

    document_content = "Information about Plaksha University"

    self_querying_retriever = SelfQueryRetriever.from_llm(
        llm=GooglePalm(),
        vectorstore=chrome_db,
        document_contents=document_content,
        metadata_field_info=metadata_info,
    )

    B_INST, E_INST = "[INST]", "[/INST]"
    B_SYS, E_SYS = "<<SYS>>\n", "\n<</SYS>>\n\n"
    DEFAULT_SYSTEM_PROMPT = """\
    You are a helpful, respectful and honest assistant. Always answer as helpfully as possible, while being safe. Your answers should not include any harmful, unethical, racist, sexist, toxic, dangerous, or illegal content. Please ensure that your responses are socially unbiased and positive in nature.

    If a question does not make any sense, or is not factually coherent, explain why instead of answering something not correct. If you don't know the answer to a question, please don't share false information."""

    sys_prompt = """You are a helpful, respectful and honest assistant. Always answer in detail as helpfully as possible using the context text provided. Your answers should answer the question once and explain your answer.

    If a question does not make any sense, or is not factually coherent, explain why instead of answering something not correct. If you don't know the answer to a question or you are not sure, please don't share false information. """

    instruction = """CONTEXT:/n/n {context}/n

    Question: {question}"""

    def get_prompt(instruction, new_system_prompt=DEFAULT_SYSTEM_PROMPT ):
        SYSTEM_PROMPT = B_SYS + new_system_prompt + E_SYS
        prompt_template =  B_INST + SYSTEM_PROMPT + instruction + E_INST
        return prompt_template

    get_prompt(instruction, sys_prompt)

    from langchain.prompts import PromptTemplate
    prompt_template = get_prompt(instruction, sys_prompt)

    llama_prompt = PromptTemplate(
        template=prompt_template, input_variables=["context", "question"]
    )

    database = 'i3_crisp'
    chrome_db = Chroma(persist_directory=f'../data/{database}', embedding_function=GooglePalmEmbeddings())
    chain_type_kwargs = {"prompt": llama_prompt}

    from langchain.chains import RetrievalQA
    qa_chain_custom_prompt = RetrievalQA.from_chain_type(
        llm=GooglePalm(), 
        chain_type="stuff", 
        retriever=self_querying_retriever,
        chain_type_kwargs=chain_type_kwargs,
        return_source_documents=True
        )

    try:
        llm_response = qa_chain_custom_prompt(query)
        response = pretty_print(llm_response)
    except IndexError as e:
        response = "Don't ask questions that you are not supposed to ask"
    return response


# Create the Streamlit app
def main():
    st.title("Plaksha Chatbot")
    # Get user input
    user_input = st.text_input("Enter your query:")

    if st.button("Generate Response"):
        # Call the RAG-based language model
        response = rag_language_model(user_input)
        # Display the response
        st.write("Response:", response)

if __name__ == "__main__":
    main()

